Scriptname SuH_contS_bloodchest extends ObjectReference 

;	Offering Chest reference script. This script holds all functions of the Offering Chest.

SuH_Status property _s auto
SuH_Fun property _f auto

Event OnInit() ; Get the scripts we need to reference
	_s = Game.GetFormFromFile(0x16E496, "Succubus Heart.esp") as SuH_Status
	_f = Game.GetFormFromFile(0x814, "Succubus Heart.esp") as SuH_Fun
endEvent

Event OnOpen(ObjectReference akActionRef)
	;Debug.MessageBox(": Make Your Offering :\n(Offered Items may be lost)") ; Display explainer message
endEvent

Event OnClose(ObjectReference akActionRef)
	string notifbuild = "" ; buliding notification list
	bool offeraccept = false ; whether offering gives rewards or not

	;	Run offering code - check for offering items, remove them and add points, spend points for offering rewards
	
	;	General Offering Point Items
	form checkform = _s.SuH_misc_bloodchip as form ; blood Chip convert to points and remove from chest
	int vx = self.GetItemCount(checkform)
	int vy = vx ; total offer count
	if vx > 0 ; if found blood chips
		_s.SuH_PCSofferpoints += (9 * vx) ; grant 9 points per-blood chip
		self.removeitem(checkform, vx, true, none) ; remove
		notifbuild += ("\nOffered "+checkform.GetName()+" x"+vx) ; add to notification
	endIf
	checkform = _s.SuH_alch_soulofdesire as form ; Soul of Desire
	vx = self.GetItemCount(checkform)
	vy += vx
	if vx > 0 ; if found Soul of Desire
		_s.SuH_PCSofferpoints += (200 * vx) ; grant 200 points per-Soul of Desire
		self.removeitem(checkform, vx, true, none)
		notifbuild += ("\nOffered "+checkform.GetName()+" x"+vx)
	endIf
	
	;	If offered items, run point check to reward item(s)
	if vy > 0
		_f.PCE_stattrack("OfferItem", vy)
		string additemnotif = _f.Offer_GetItem(3) ; Check if we get item, add return string to notification
		if additemnotif != "" ; if offer was excepted as there's notifications to add
			notifbuild += additemnotif
			offeraccept = true ; set reward recieved
		endIf
	endIf
	
	;	Run Conversion Code - Check for specific items to convert into merged versions
	
	;	Sperm Conversion
	checkform = _s.SuH_alch_sperm as form ; Sperm
	vx = self.GetItemCount(checkform)
	if vx > 24 ; if 25 or more
		vy = (vx / 25) ; get conversion amount
		self.removeitem(checkform, (vy * 25), true, none) ; remove
		offeraccept = true ; set reward recieved
		notifbuild += ("\nOffered "+checkform.GetName()+" x"+(vy * 25)+"\nRewarded "+_s.SuH_alch_sperm25.GetName()+" x"+vy) ; add to notification
		_s.PlayerRef.AddItem(_s.SuH_alch_sperm25, vy)
	endIf
	checkform = _s.SuH_alch_spermcreature as form ; Sperm
	vx = self.GetItemCount(checkform)
	if vx > 24 ; if 25 or more
		vy = (vx / 25) ; get conversion amount
		self.removeitem(checkform, (vy * 25), true, none) ; remove
		offeraccept = true ; set reward recieved
		notifbuild += ("\nOffered "+checkform.GetName()+" x"+(vy * 25)+"\nRewarded "+_s.SuH_alch_spermcreature25.GetName()+" x"+vy) ; add to notification
		_s.PlayerRef.AddItem(_s.SuH_alch_spermcreature25, vy)
	endIf
	
	;	Milk Conversion
	checkform = _s.SuH_alch_milk as form ; Sperm
	vx = self.GetItemCount(checkform)
	if vx > 19 ; if 20 or more
		vy = (vx / 20) ; get conversion amount
		self.removeitem(checkform, (vy * 20), true, none) ; remove
		offeraccept = true ; set reward recieved
		notifbuild += ("\nOffered "+checkform.GetName()+" x"+(vy * 20)+"\nRewarded "+_s.SuH_alch_milk20.GetName()+" x"+vy) ; add to notification
		_s.PlayerRef.AddItem(_s.SuH_alch_milk20, vy)
	endIf
	checkform = _s.SuH_alch_milkcreature as form ; Sperm
	vx = self.GetItemCount(checkform)
	if vx > 19 ; if 20 or more
		vy = (vx / 20) ; get conversion amount
		self.removeitem(checkform, (vy * 20), true, none) ; remove
		offeraccept = true ; set reward recieved
		notifbuild += ("\nOffered "+checkform.GetName()+" x"+(vy * 20)+"\nRewarded "+_s.SuH_alch_milkcreature20.GetName()+" x"+vy) ; add to notification
		_s.PlayerRef.AddItem(_s.SuH_alch_milkcreature20, vy)
	endIf
	
	;	Soul Conversion
	checkform = _s.SuH_alch_soulofexperience as form ; Sperm
	vx = self.GetItemCount(checkform)
	if vx > 24 ; if 25 or more
		vy = (vx / 25) ; get conversion amount
		self.removeitem(checkform, (vy * 25), true, none) ; remove
		offeraccept = true ; set reward recieved
		notifbuild += ("\nOffered "+checkform.GetName()+" x"+(vy * 25)+"\nRewarded "+_s.SuH_alch_soulofexperience25.GetName()+" x"+vy) ; add to notification
		_s.PlayerRef.AddItem(_s.SuH_alch_soulofexperience25, vy)
	endIf
	checkform = _s.SuH_alch_soulofforce as form ; Sperm
	vx = self.GetItemCount(checkform)
	if vx > 24 ; if 25 or more
		vy = (vx / 25) ; get conversion amount
		self.removeitem(checkform, (vy * 25), true, none) ; remove
		offeraccept = true ; set reward recieved
		notifbuild += ("\nOffered "+checkform.GetName()+" x"+(vy * 25)+"\nRewarded "+_s.SuH_alch_soulofforce25.GetName()+" x"+vy) ; add to notification
		_s.PlayerRef.AddItem(_s.SuH_alch_soulofforce25, vy)
	endIf
	checkform = _s.SuH_alch_souloflife as form ; Sperm
	vx = self.GetItemCount(checkform)
	if vx > 24 ; if 25 or more
		vy = (vx / 25) ; get conversion amount
		self.removeitem(checkform, (vy * 25), true, none) ; remove
		offeraccept = true ; set reward recieved
		notifbuild += ("\nOffered "+checkform.GetName()+" x"+(vy * 25)+"\nRewarded "+_s.SuH_alch_souloflife25.GetName()+" x"+vy) ; add to notification
		_s.PlayerRef.AddItem(_s.SuH_alch_souloflife25, vy)
	endIf
	checkform = _s.SuH_alch_soulofmagic as form ; Sperm
	vx = self.GetItemCount(checkform)
	if vx > 24 ; if 25 or more
		vy = (vx / 25) ; get conversion amount
		self.removeitem(checkform, (vy * 25), true, none) ; remove
		offeraccept = true ; set reward recieved
		notifbuild += ("\nOffered "+checkform.GetName()+" x"+(vy * 25)+"\nRewarded "+_s.SuH_alch_soulofmagic25.GetName()+" x"+vy) ; add to notification
		_s.PlayerRef.AddItem(_s.SuH_alch_soulofmagic25, vy)
	endIf
	checkform = _s.SuH_alch_soulofpower as form ; Sperm
	vx = self.GetItemCount(checkform)
	if vx > 24 ; if 25 or more
		vy = (vx / 25) ; get conversion amount
		self.removeitem(checkform, (vy * 25), true, none) ; remove
		offeraccept = true ; set reward recieved
		notifbuild += ("\nOffered "+checkform.GetName()+" x"+(vy * 25)+"\nRewarded "+_s.SuH_alch_soulofpower25.GetName()+" x"+vy) ; add to notification
		_s.PlayerRef.AddItem(_s.SuH_alch_soulofpower25, vy)
	endIf
	
	;	Display notification
	if notifbuild != "" ; if there are notifications to show
		if offeraccept == true ; if player was rewarded for offer
			debug.MessageBox(": Offer Accepted :"+notifbuild)
		else ; if no reward was given
			debug.MessageBox(": Offer Rejected :"+notifbuild)
		endIf
	endIf
endEvent
